using System;
using System.Collections.Generic;
using System.Text;
using System.IO;

namespace XmlExporter
{
    public class Log
    {
        private FileInfo logFileInfo;
        private FileStream logFile;
        private StreamWriter logStream;
        private string filePath = "";

        public Log()
        {
            this.filePath = System.Reflection.Assembly.GetExecutingAssembly().Location;
            int length = this.filePath.LastIndexOfAny(new char[2] { '\\', '/' });
            this.filePath = this.filePath.Substring(0, length + 1);
        }

        public void Initialize()
        {
            logFileInfo = new FileInfo(this.filePath + "xmlExportLog.txt");
            logFile = logFileInfo.Open(FileMode.Create);
            logFile.Close();
        }
        
        public void WriteLogLine(string line)
        {
            logStream = new StreamWriter(this.filePath + "xmlExportLog.txt", true);
            logStream.WriteLine(line);
            logStream.Close();
        }
    }
}
