using System;
using System.Collections.Generic;
using System.Text;
using NWN2Toolset.Plugins;
using TD.SandBar;
using System.Xml;
using System.Windows.Forms;
using NWN2Toolset.NWN2.Data;
using NWN2Toolset.NWN2.Data.TypedCollections;
using NWN2Toolset.NWN2.Data.ConversationData;

namespace XmlExporter
{
    public class XmlExporter : INWN2Plugin
    {
        private MenuButtonItem menuItem;

        private XmlExporterForm pluginForm;

        private OpenFileDialog openFile;

        private ImportAs importForm;

        public Log log;
        
        public MenuButtonItem PluginMenuItem
        {
            get
            {
                return menuItem;
            }
        }

        public void Load(INWN2PluginHost host)
        {
        }

        public void Shutdown(INWN2PluginHost host)
        {

        }

        public void Startup(INWN2PluginHost host)
        {
            log = new Log();
            log.Initialize();
            menuItem = host.GetMenuForPlugin(this);
            menuItem.Items.Add("Export", new EventHandler(exportActivate));
            menuItem.Items.Add("Import", new EventHandler(importActivate));
        }

        private void exportActivate(object sender, EventArgs e)
        {
            pluginForm = new XmlExporterForm(log);
            pluginForm.Show();
        }

        private void importActivate(object sender, EventArgs e)
        {
            openFile = new OpenFileDialog();
            openFile.Filter = "xml files (*.xml)|*.xml|All files (*.*)|*.*";
            openFile.Title = "Select xml-formatted file to import";
            openFile.Multiselect = false;
            if (openFile.ShowDialog() == DialogResult.OK)
            {
                string shortFilename = GetShortFileNameNoExtension(openFile.FileName);
                importForm = new ImportAs(shortFilename);
                importForm.ShowDialog();
                if (importForm.OK == true)
                {
                    importForm.Close();
                    Conversation conversation = Conversation.GetConversation(openFile.FileName, log);
                    conversation.SetMyConversationForSubnodes();
                    conversation.ConversationToNWN2(importForm.conversationNameBox.Text);
                }
            }
        }

        public static string GetShortFileName(string fileName)
        {
            char[] slashes = new char[2] { '/', '\\' };
            return fileName.Substring(fileName.LastIndexOfAny(slashes) + 1);
        }

        public static string GetShortFileNameNoExtension(string fileName)
        {
            fileName = GetShortFileName(fileName);
            return fileName.Substring(0, fileName.LastIndexOf('.'));
        }

        public static string GetFilePath(string fileName)
        {
            char[] slashes = new char[2] { '/', '\\' };
            return fileName.Substring(0, fileName.LastIndexOfAny(slashes) + 1);
        }

        public void Unload(INWN2PluginHost host)
        {

        }

        public string DisplayName
        {
            get
            {
                return "Xml Export/Importer";
            }
        }

        public string MenuName
        {
            get
            {
                return "Xml Export/Importer";
            }
        }

        public string Name
        {
            get
            {
                return "XmlExportImporter";
            }
        }

        public object Preferences
        {
            get
            {
                return null;
            }
            set
            {

            }
        }


    }
}
