using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using NWN2Toolset.NWN2.Data;
using NWN2Toolset.NWN2.Data.TypedCollections;
using NWN2Toolset.NWN2.Data.ConversationData;

namespace XmlExporter
{
    public partial class XmlExporterForm : Form
    {
        public NWN2GameConversation[] conversations;

        public Log log;

        public XmlExporterForm(Log myLog)
        {
            log = myLog;
            InitializeComponent();
            NWN2GameConversationDictionary dictionary = NWN2Toolset.NWN2ToolsetMainForm.App.Module.Conversations;
            int num = dictionary.Values.Count;
            conversations = new NWN2GameConversation[dictionary.Values.Count];
            dictionary.Values.CopyTo(conversations, 0);
            conversations = SortArray(conversations);
            foreach (NWN2GameConversation cn in conversations)
            {
                this.listBox1.Items.Add(cn.Name);
            }
        }

        NWN2GameConversation[] SortArray(NWN2GameConversation[] arrayToSort)
        {
            NWN2GameConversation[] newArray = new NWN2GameConversation[arrayToSort.Length];
            NWN2GameConversation tempConversation;
            for (int i = 0; i < newArray.Length; i++)
            {
                tempConversation = null;
                foreach (NWN2GameConversation step in arrayToSort)
                {
                    if (!ArrayContains(newArray, step))
                    {
                        if (tempConversation == null)
                        {
                            tempConversation = step;
                        }
                        else
                        {
                            if (String.Compare(step.Name, tempConversation.Name, true) < 0)
                            {
                                tempConversation = step;
                            }
                        }
                    }
                }
                newArray[i] = tempConversation;
            }
            return newArray;
        }

        bool ArrayContains(NWN2GameConversation[] arrayToSearch, NWN2GameConversation itemToSearchFor)
        {
            foreach (NWN2GameConversation item in arrayToSearch)
            {
                if (item == itemToSearchFor)
                {
                    return true;
                }
            }
            return false;
        }

        private void buttonExport_Click(object sender, EventArgs e)
        {
            DialogResult saveDirectory = selectSaveDirectory.ShowDialog();
            if (saveDirectory == DialogResult.Cancel)
            {

            }
            else if (saveDirectory == DialogResult.OK)
            {
                string filePath = selectSaveDirectory.SelectedPath;
                foreach (int index in listBox1.SelectedIndices)
                {
                    ExportConversation(conversations[index], filePath + "\\" + conversations[index].Name + ".xml");
                }
                this.Close();
            }
        }

        private void buttonCancel_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void ExportConversation(NWN2GameConversation conv, string fileName)
        {
            conv.Demand();
            ContentNode newNode;
            NWN2ConversationConnector connector;
            Conversation conversation = Conversation.NWN2ToConversation(conv, log);
            conversation.log = log;
            for (int i = 0; i < conv.StartingList.Count; i++)
            {
                connector = conv.StartingList[i];
                newNode = ContentNode.NodeFromNWN2Connector(connector, i + 1, ConversationNodeType.NPC, conversation);
                conversation.subNodes.Add(newNode);
            }
            conversation.ConnectAllLinks();
            conversation.SaveContentConversation(fileName);
        }
    }
}